--[[--
Converted-Selected-Bezier-to-BSpline-Polyline.lua

This tool converts all selected Bezier BSpline PolyLine masks 

Requires   : Fusion 6.3 Build 982 or later
Written By : Srecko Zrilic [srecko@eyeonline.com]
Written On : Friday 12th of October 2012
--]]--


if tool == nil or tool.ID ~= "PolylineMask" and tool.ID ~= "BSplineMask" then
	print("Run this script on a Polyline Mask")
	exit()
end


local toollist = comp:GetToolList(true)

local toolx = nil
local num_shapes = 0
for j, vv in pairs(toollist) do
	if vv:GetID() == "PolylineMask" or vv:GetID() == "BSplineMask" then
		num_shapes = num_shapes + 1
		toolx = vv
	end
end

if toolx ~= tool then
	exit()
end

if num_shapes < 1 then
	print("No selected masks\n")
	exit()
end

comp:StartUndo("Convert Bezier to BSpline Polylines")

for i, v in pairs(toollist) do
	if v:GetID() == "PolylineMask" or v:GetID() == "BSplineMask" then
		v:ConvertToBSpline()
	end
end
comp:EndUndo(true)
